<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ABM de Registros</title>
</head>
<body>
    <h2>Operaciones de Alta, Baja y Cambio</h2>

    <?php
    // Conexión a la base de datos
    $conn = new mysqli('localhost', 'root', '', 'rdiscrepancias');

    // Verificar conexión
    if ($conn->connect_error) {
        die("Error de conexión: " . $conn->connect_error);
    }

    // Consulta para obtener los registros de la tabla
    $sql = "SELECT seq, plazacobro FROM plazadecobro";
    $result = $conn->query($sql);

    // Verificar si hay registros
    if ($result->num_rows > 0) {
        // Mostrar formulario de selección de registros
        echo "<form method='post' action='procesar.php'>";
        while ($row = $result->fetch_assoc()) {
            echo "<input type='checkbox' name='registros[]' value='" . $row["seq"] . "'>" . $row["pazacobro"] . "<br>";

            // Mostrar campo para texto adicional solo si la opción es "cambio"
            echo "<label for='opcion'>Selecciona una opción A, B o C:</label>";
            echo "<select name='opcion_" . $row["seq"] . "' id='opcion_" . $row["seq"] . "'>";
            echo "<option value='A'>A</option>";
            echo "<option value='B'>B</option>";
            echo "<option value='C'>C</option>";
            echo "</select>";

            // Mostrar campo para texto adicional solo si la opción es "cambio"
            echo "<br>";
            echo "<label for='texto_accion'>Texto adicional:</label>";
            echo "<input type='text' name='texto_accion_" . $row["seq"] . "' id='texto_accion_" . $row["seq"] . "'>";
            echo "<br><br>";
        }

        // Mostrar campo para texto adicional para el alta
        echo "<label for='texto_accion'>Texto adicional para el alta:</label>";
        echo "<input type='text' name='texto_accion_alta' id='texto_accion_alta'>";

        // Mostrar botón de envío
        echo "<br><br>";
        echo "<input type='submit' value='Ejecutar acción'>";
        echo "</form>";
    } else {
        echo "No hay registros disponibles.";
    }

    // Cerrar la conexión
    $conn->close();
    ?>
</body>
</html>
